#####################################################################
#                                                                   #
# Vzorovy skript pro automatickou upravu namelistu (abyste na nic   #
# nezapomneli :-) a hromadne spousteni. Radsi ale ZKONTROLUJTE!     #
#                                                                   #
# Predpoklada, ze udaje o zdrojich jsou v                           #
#     ./${scenar}/zdroje_${scenar}_VSE_souradnice.csv               #
#     ./${scenar}/zdroje_${scenar}_VSE_emise_${spec_in}.csv         #
#                                                                   #
# Ostatni vstupy jsou spolecne.                                     #
#                                                                   #
#####################################################################

#!/bin/bash

scenar='P1a2'

for spec in BaP CO C6H6 NOx NO2 PM10 PM2_5 SO2; do
    spec_in=$spec
    if [ $spec = "BaP" ] ; then
        spec_in="BaP_mg"
    fi

    is_no='.FALSE.'
    if [ $spec = "NO2" ] ; then
        is_no=".TRUE."
    fi

    trida_lat=2
    if [ $spec = "CO" ] ; then
        trida_lat=3
    fi

    is_daily='.FALSE.'
    daily_type=""
    if [ $spec = "PM10" ] || [ $spec = "SO2" ] ; then
        is_daily=".TRUE."
        if [ $spec = "PM10" ] ; then
            daily_type="PM10"
        else
            daily_type="SO2"
        fi
    fi

    is_max_abs=".TRUE."
    if [ $spec = "BaP" ] || [ $spec = "C6H6" ] || [ $spec = "PM2_5" ] ; then
        is_max_abs=".FALSE"
    fi

    shortterm_avg=60
    if [ $spec = "CO" ] ; then
       shortterm_avg=480 
    fi

    ini_file="./symos_in_${scenar}_${spec}.ini"

# zapis ridiciho namelistu
cat << EOF > $ini_file
&init
 ! ----------------------------------------------------------------!
 ! spolecne nastaveni pro vypocet dle metodiky i s casovymi radami !
 ! ----------------------------------------------------------------!

 ! cesta k adresari se vstupnimi daty
 iputDir = './'

 ! cesta k adresari se vystupnimi daty
 oputDir = './'

 ! nazev vstupniho souboru s referencnimi body
 ref_body_file = 'RB/ref_body.csv'

 ! nazev vstupniho souboru s definici zdroju
 zdroje_file = "${scenar}/zdroje_${scenar}_VSE_souradnice.csv"

 ! nazev vstupniho souboru s popisem zdroju
 zdroje_popis_file = "${scenar}/zdroje_${scenar}_VSE_emise_${spec_in}.csv"

 ! nazev vstupniho souboru s vyskopisem
 vyskopis_file = 'vyskopis/vyskocr_25m_s42.txt'

 !nazev souboru se vstupy pro chladici veze. Je potreba pouze, pokud je mezi vstupnimi zdroji chladici vez.
 chl_v_file = 'chl_veze.csv'

 ! cas prumerovani kratkodobych koncentraci v minutach
 shortterm_avg = $shortterm_avg

 ! oddelovac sloupcu ve vystupnim souboru (max. 10 znaku)
 delim_out = ';'

 ! pocitat s konverzi NO na NO2 ?
 is_no = $is_no

 ! pocitat se shluky
 is_shluky = .FALSE.

 ! volna atmosfera
 free_atmo = .TRUE.

 ! uvazovat staceni vetru
 wind_rotation = .TRUE.

 ! zpusob vypoctu Q dle rovnice 2.10
 ! urcuje zda pouzit vzorec z metodiky ('metodika') nebo ze vyzkumne zpravy ('vyzk-zpr')
 tep_vyd_type = 'metodika'

 ! velikost kroku pro integraci [m]
 int_err = 10

 ! trida latky (tabulka 3.7) - vyber 1, 2, 3
 trida_lat = $trida_lat

 ! vzdalenost od ktere maji zdroje vliv [m]
 infl_dist_min = 0

 ! vzdalenost do ktere maji zdroje vliv [m]
 infl_dist_max = 100000

 ! ----------------------------------------------------------------!
 !                konec spolecneho nastaveni                       !
 ! ----------------------------------------------------------------!

   ! ----------------------------------------------------------------------------!
   ! nastaveni pro vypocet z casovych rad. nepouzije se, pokud (is_time=.FALSE.) !
   ! ----------------------------------------------------------------------------!

   ! .TRUE. pokud jsou na vstupu hodinove meteorologicke vstupy a chceme pocitat hodinovou radu
   is_time = .FALSE.

   ! nazev vstupniho souboru s meteorologickymi hodinovymi vstupy
   time_file = 'example_meteo_cas-rada.csv'

   ! nazev vstupniho souboru s meteorologickymi hodinovymi vstupy
   emis_time_file = 'example_emis_cas-rada.csv'

   ! v meteorologickem vstupu je zadan teplotni gradient (.TRUE.) nebo trida stability (.FALSE.)
   is_tep_gr = .TRUE.

   ! vyska vetru [m] (plati pouze pro hodinovy vypocet)
   u_height = 10

   ! nazev vystupniho souboru s hodinovymi vystupy
   output_time = 'time.csv'

   ! .TRUE. pokus chci vypsat casovy vyvoj pro vsechny ref. body
   ! pokud .FALSE. vypise jen body zadane v souboru output_ref_p
   time_output_all = .FALSE.
  
   ! sobour s id ref. bodu, ktere chci vypsat do output_time
   output_ref_p = 'example_output_ref_p.csv'

   ! zda se budou zohlednovat inverze
   inverze = .TRUE.
   ! ----------------------------------------------------------------------------!
   ! konec nastaveni pro vypocet z casovych rad                                  !
   ! ----------------------------------------------------------------------------!

! -------------------------------------------------------------------------------------!
! nasledujici radky se tykaji standardniho vypoctu dle metodiky (maxima, ruzice a tak) !
! pokud budou vsechny logicke promenne .FALSE., pak se nic pocitat nebude              !
! -------------------------------------------------------------------------------------!

 ! nazev vstupniho souboru s ruzici
 ruzice_file = 'VR/VR_Pavlov_symos.txt'

 ! nazev vystupniho souboru pro maximalni a prumerne (dle ruzice) koncentrace + doby prekroceni
 output_stats = "symos_out_${scenar}_${spec}.csv"

 ! krok pro rozpocet ruzice [deg]
 phi_step = 1

 ! .TRUE. pokud se ma pocitat rocni prumer
 is_average = .TRUE.

 ! .TRUE. pokud se bude pocitat absolutni maximum
 is_max_abs = $is_max_abs

 ! .TRUE. pokud se budou pocitat maxima pro 11 rozptylovych trid
 is_max_11 = .TRUE.

 ! .TRUE. pokud se budou pocitat i denni statistiky (max_abs, max_11, exceed)
 is_daily = ${is_daily}

   ! typ vypoctu pro denni maxima ('SO2' nebo 'PM10')
   daily_type = '${daily_type}'


 ! pocitat doby prekroceni? 
 is_exceed = .FALSE.

   ! prahove hodnoty pro HODINOVE (resp. 30min, 60min, 8h) koncentrace
   ch_exceed = 0.057, 0.083, 0.177

   ! prahove hodnoty pro DENNI koncentrace
   cd_exceed = 0.057, 0.083, 0.177

/

EOF

# vzor spusteni na lokalnim stroji
# ./symos.exe $ini_file

# vzor spusteni na clusteru
# qsub -N sym_${spec} -pe openmp 48 -q default.q -cwd -o ./run_symos_${spec}.log -e ./run_symos_${spec}.log  -b y time -p ./symos.exe $ini_file

done

